local player = Var "Player"
local blinkTime = 1.2
local barWidth = 32;
local barHeight = 230;
local c;
local LifeMeter, MaxLives, CurLives;
local LifeRatio;

local t = Def.ActorFrame {
	Def.Sprite {
		Texture=GAMESTATE:IsExtraStage2() and "_cursedheart" or "_lives";
		InitCommand=cmd(pause;horizalign,left;x,-135;y,-5);
		BeginCommand=function(self,param)
			local screen = SCREENMAN:GetTopScreen();
			local glifemeter = screen:GetLifeMeter(player);
				if glifemeter:GetTotalLives() > 4 then
					self:setstate(4) -- golden hearts!
				else
					self:setstate(clamp(glifemeter:GetTotalLives()-1,0,9));
				end

				if GAMESTATE:IsExtraStage2() then -- cursed heart, Another Stage
					self:addx(-50):zoom(1.25):bob():effectperiod(4)
				end
		end;
		LifeChangedMessageCommand=function(self,param)
			if param.Player == player then
				if param.LivesLeft == 0 then
					self:visible(false)
				else
					if param.LivesLeft > 4 then
						self:setstate(4)
						self:visible(true)
					else
						self:setstate( clamp(param.LivesLeft-1,0,9) )
						self:visible(true)
					end
					if param.LivesLeft == 1 then
						if GAMESTATE:IsExtraStage2() then
							return
						else
							self:vibrate()
						end
					end
				end
			end
		end;
		StartCommand=function(self,param)
			if param.Player == player then
				if param.LivesLeft > 4 then
					self:setstate(4)
				else
					self:setstate( clamp(param.LivesLeft-1,0,9) );
				end
			end			
		end;
		FinishCommand=cmd(playcommand,"Start");
	};
	LoadFont("_coaster")..{
		Condition=not GAMESTATE:IsExtraStage2();
		InitCommand=function(self) self:x(-80):y(240):zoom(2):strokecolor(color("#000000")) end;
		OnCommand=function(self,param)
		local screen = SCREENMAN:GetTopScreen();
		local glifemeter = screen:GetLifeMeter(player);
		self:settextf("x%i",glifemeter:GetTotalLives())
		self:strokecolor(color("#000000")) end;
		LifeChangedMessageCommand=function(self,param)
		self:settextf("x%i",param.LivesLeft) 
		local oops = param.LostLife;
			if oops then
				self:zoom(2.5):linear(0.15):zoom(2)
			end
		end;
	};
};

return t;